window.addEventListener('DOMContentLoaded', function () {
    console.log('Loading application')
    Array.prototype.forEach.call(document.querySelectorAll('[vb-key]'), function (el) {
        var key = el.getAttribute('vb-key')
        var icon = el.getAttribute('icon')
        var label = el.innerText
        el.innerHTML = ''

        var img = document.createElement('img')
        img.src = icon
        el.appendChild(img)
        var label_c = document.createElement('span')
        label_c.innerText = label
        el.appendChild(label_c)

        var thumb = document.createElement('div')
        thumb.classList.add('thumb')
        thumb.classList.add('hidden')
        el.appendChild(thumb)

        el.classList.add('menu-item')
        el.onclick = function (e) {
            // e.preventDefault()
            // e.stopPropagation()
            BUTTON_BRIDGE.setAttribute('vb-key', el.getAttribute('vb-key'))
            BUTTON_BRIDGE.click()
        }
    })
})

function notifyMenu(key, num, type) {
    var el = document.querySelector('[vb-key="' + key + '"] .thumb')
    if (el) {
        el.classList.remove('hidden')
        el.innerText = Number(num) > 9 ? '9+' : num
        if (Number(num) <= 0) {
            el.classList.add('hidden')
        }
    } else {
        return false
    }
    if (type) {
        el.classList.add(type)
    }
}

function clearNotify() {
    var els = document.querySelectorAll('[vb-key] .thumb')
    Array.prototype.forEach.call(els, function (el) {
        el.classList.add('hidden')
    })
}

function hideMenu(key) {
    var el = document.querySelector('[vb-key="' + key + '"]')
    el.classList.add('hidden')
}

function showMenu(key) {
    var el = document.querySelector('[vb-key="' + key + '"]')
    el.classList.remove('hidden')
}

// notifyMenu('NOME_MENU_VB', 9)

// clearNotify()


function adicionarItem(text, value) {
    // Passo 1: Obtenha uma referência para o elemento select
    var select = document.getElementById("meuDd");

    // Passo 2 a 4: Crie um novo elemento option
    var novoOption = document.createElement("option");
    novoOption.innerText = text;
    if (value) novoOption.value = value;

    // Passo 5: Adicione o novo option ao select
    select.appendChild(novoOption);
}